


/******************************************************************************************************
 **                                                                                                  **
 **        Example1 : Test Board ET-Mini Microstep Driver (2Channel)                                 **
 **                   use Stepping Motor Bipolar  14PM-M252 : 24V ,coil 500mA,Step 1.8 degree        **
 **                                                                                                  **                                           
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         : Arduino-MEGA328 (Board ET-BASE AVR EASY328                                 **
 **                     : X-TAL : 16 MHz                                                             ** 
 **                                                                                                  **
 **  Editor/Compiler    : Arduino 1.8.15                                                             **
 **                                                                                                  **                   
 **  Port Interface     :    Arduino Mega328 PIN                      ET-MicroStep                   **
 **                         ----------------------                  --------------                   **
 **   Control Motor1    :  PIN D8(Out)                Connect        DR1 Pin                         **                                                                                    
 **                            D9(Out)                Connect        ST1 Pin                         **
 **                           D10(Out)                Connect        EN1 Pin                         **
 *                                                                                                   **                           
 **  Control Motor2    :  PIN D11(Out)                Connect        DR2 Pin                         **                                                                                    
 **                           D12(Out)                Connect        ST2 Pin                         **
 **                           D13(Out)                Connect        EN2 Pin                         **
 **                                                                                                  **
 **  Jumper Setting    :  Jumper Step Mode-M1,M2      =   M0,M1,M2 = Low = Full Step                 **                                                                                                  
 **                       Use Frequency Step Pulse    =  500Hz                                       **   
 **                       Jumper ENA1,ENA2            =   Ctr = Select Control (Enable=0)            ** 
 **                       Vref = Current limit/2 = 500ma/2 = 0.25 V                                  **                         
 **                                                                                                  **
 **     Operation      : Stepping Motor CH1 ,CH2 rotate CW 2 round and  chang Direction              **                                                                                                         
 **                      Rotate CCW 1 round  then repeat loop all again                              **     
 **                                                                                                  **
 **  Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                        **
 **  Last Update       : 2/October/2018                                                              ** 
 **                                                                                                  ** 
 ******************************************************************************************************/

//--------- Define Pin Control  Stepping Motor  CH1 --------------
#define DR1      8     //  D8  = Direction CH1 
#define ST1      9     //  D9  = Signal Step Pule CH1
#define EN1      10    //  D10 = Enable Driver CH1 (0=Active)

//--------- Define Pin Control  Stepping Motor  CH2 --------------
#define DR2      11    //  D11  = Direction CH2 
#define ST2      12    //  D12  = Signal Step Pule CH2
#define EN2      13    //  D13  = Enable Driver CH2 (0=Active)


//############### SEt Up  #################
void setup()
{

 //-------Set I/O Pin Control CH1,CH2 ---------
  pinMode(DR1,OUTPUT );
  pinMode(ST1,OUTPUT );
  pinMode(EN1,OUTPUT );
  
  pinMode(DR2,OUTPUT );
  pinMode(ST2,OUTPUT );
  pinMode(EN2,OUTPUT );

//-------Set Default Pin Control CH1,CH2-------
  digitalWrite( EN1,HIGH) ;  //Disable Driver CH1 
  digitalWrite( EN2,HIGH) ;  //Disable Driver CH2
  
  digitalWrite( ST1,LOW) ;  //Set Step Pluse CH1 = 0 :Stop Motor 
  digitalWrite( ST2,LOW) ;  //Set Step Pluse CH2 = 0:Stop Motor 
  
}


//###################### Main Loop #######################

void loop()
{
  int i = 0;
 
 delay(100);
 digitalWrite(EN1,LOW) ;  // Enable Driver CH1
 digitalWrite(EN2,LOW) ;  // Enable Driver CH2
 
 while(1)
  {
   //--------Direction = CW ------------    
    digitalWrite(DR1,HIGH);    //Set Direction CH1= CW
    digitalWrite(DR2,HIGH);    //Set Direction CH2 =CW
 
    for( i=0; i<400; i++)              //Loop Motor Rotate 2 round 
     {                                 //whaen Full Step Mode = 200 Pulse/Round (360/[1.8*1]=200),F=500Hz
       digitalWrite(ST1,HIGH )      ;  //Write Pluse+ to CH1 
       digitalWrite(ST2,HIGH )      ;  //Write Pluse+ to CH2 
       delayMicroseconds(1000)      ;  //delay Pulse High wide 1ms
       digitalWrite(ST1,LOW )       ;  //Write Pluse- to CH1 
       digitalWrite(ST2,LOW )       ;  //Write Pluse- to CH2 
       delayMicroseconds(1000)      ;  //delay Pulse Low wide 1ms
     } 
  
    delay(500); //delay Stop Motor 500 ms befor Chang Direction
    
    //-------- Chang Direction= CCW -------------
    
    digitalWrite(DR1,LOW);            //Set Direction CH1 = CCW
    digitalWrite(DR2,LOW);            //Set Direction CH2 = CCW
    
    for( i=0; i<200; i++)             //Loop Motor Rotate 1 round 
     {                                //Full Step Mode = 200 Pulse/Round (360/1.8=200),F=0.5KHz
       digitalWrite(ST1,HIGH )      ;  //Write Pluse+ to CH1 
       digitalWrite(ST2,HIGH )      ;  //Write Pluse+ to CH2 
       delayMicroseconds(1000)      ;  //delay Pulse High wide 1ms
       digitalWrite(ST1,LOW )       ;  //Write Pluse- to CH1 
       digitalWrite(ST2,LOW )       ;  //Write Pluse- to CH2 
       delayMicroseconds(1000)      ;  //delay Pulse Low wide 1ms
     } 

    delay(500) ; //delay Stop Motor 500 ms befor Chang Direction
    
 } //while
 
}








